set more off
use /mcr/cps/matched/data/matched.dta, clear

drop if mlr==-1 | mlr==.

replace mlr=8 if (wantjob==1111 | wantjob==1112 | wantjob==1120 | wantjob==1200)

collapse (sum) sswgt, by(mdate mlr)
gen wgt=sswgt/(1000)
drop sswgt

reshape wide wgt, i(mdate) j(mlr)

gen pop = wgt1+wgt2+wgt3+wgt4+wgt5+wgt6+wgt7+wgt8
gen wj  = wgt8
gen dwj = wgt5+wgt6+wgt7
gen dis = wgt6
gen ret = wgt5

drop wgt*

gen wj_r            =  wj/pop
gen dwj_r           = dwj/pop
gen dwj_notretdis_r = (dwj-ret-dis)/pop

tsset mdate, m

foreach var in wj_r dwj_r dwj_notretdis_r {
tssmooth ma `var'_12 = `var',window(11 1 0)
}

keep  if mdate>=tm(1995m1)

gen  wj_r_12n = wj_r_12 - wj_r_12[1]
gen dwj_r_12n =dwj_r_12 -dwj_r_12[1]
gen dwj_notretdis_r_12n = dwj_notretdis_r_12 - dwj_notretdis_r_12[1]

tsline wj_r_12n dwj_r_12n dwj_notretdis_r_12n  if tin(1995m1, 2014m6), ttitle("") tline(2001m3(1)2001m11 2007m12(1)2009m6, lc(gs12) lw(thick)) title("Not in Labor Force, 12mma") 
